<?
	// Change this path to match your UnlockBase API.php path
	require('API/Library/API.php');
	
	// This is the folder in which the cache file will be stored
	// We use the system temp dir if known, of the current folder as an alternative
	define('TOOLS_CACHE_DIR', function_exists('sys_get_temp_dir') ? sys_get_temp_dir() : '.');

	// This is the default cache file name
	// There is no need to change it, unless this is a problem for you
	define('TOOLS_CACHE_FILE', 'tools.cache.xml');
	
	// The full path to the cache file
	define('TOOLS_CACHE_PATH', TOOLS_CACHE_DIR . '/' . TOOLS_CACHE_FILE);
	
	// We now check that we can read & write the cache dir, thus use the cache file
	define('TOOLS_CACHE', is_readable(TOOLS_CACHE_DIR) && is_writable(TOOLS_CACHE_DIR));
	
	function error()
	{
		// In case of a communication error,
		// send a 503 (Service Unavailable) error
		header(' ', true, 503);	
		exit;
	}
	
	// Some compat functions, for those who use old versions of PHP
	if (! function_exists('file_get_contents'))
	{
		function file_get_contents($file)
		{
			$data = '';
			$fp = fopen($file, 'rb');
			while (! feof($fp)) $data .= fread($fp, 1024);
			fclose($fp);
			return $data;
		}
	}
	
	if (! function_exists('file_put_contents'))
	{
		function file_put_contents($file, $data)
		{
			$fp = fopen($file, 'wb');
			fwrite($fp, $data);
			fclose($fp);
		}
	}

	// Initialize message variables
	$error = $warning = $success = false;
	
	if (isset($_POST['IMEI']) && (trim($_POST['IMEI']) != ''))
	{
		// If a recent cache file exists, use it
		if (TOOLS_CACHE && file_exists(TOOLS_CACHE_PATH) && time() - filemtime(TOOLS_CACHE_PATH) < 24 * 3600) $xml = file_get_contents(TOOLS_CACHE_PATH);
		
		// Get the tool list from the UnlockBase API
		else
		{
			$xml = UnlockBase::CallAPI('GetTools');
			if (TOOLS_CACHE) file_put_contents(TOOLS_CACHE_PATH, $xml);
		}
		
		if (! is_string($xml)) error();
		
		// Parse the tool list
		$xml = UnlockBase::ParseXML($xml);
		if (! is_array($xml)) error();
		
		// Build an associative array with the tool groups & names
		$tools = array();
		
		foreach ($xml['Group'] as $group)
		{
			foreach ($group['Tool'] as $tool)
			{
				$tools[$tool['ID']] = array($group['Name'], $tool['Name']);
			}
		}

		// Call the HTC API with the given IMEI
		$url = 'http://www.unlockbase.com/xml/api/htc.php?IMEI=' . urlencode($_POST['IMEI']);
		$xml = @ file_get_contents($url);
		if (! is_string($xml)) error();
		
		$xml = UnlockBase::ParseXML($xml);
		if (! is_array($xml)) error();

		if (isset($xml['Tool']))
		{
			if (isset($tools[$xml['Tool']]))
			{
				list ($Group, $Tool) = $tools[$xml['Tool']];
				$success = 'The following tool is available for your IMEI :' . PHP_EOL . $Group . ' > ' . $Tool;
			}
			else
			{
				$warning = 'No HTC tool is available for your IMEI.';
			}
		}
		elseif (isset($xml['Error']))
		{
			$error = $xml['Error'];
		}
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>HTC Tool advisor</title>
<style type="text/css">
	body {
		font-family: Arial, Helvetica, sans-serif;
		font-size: 15px;
		color: #333333;
	}
	.error, .warning, .success {
		border-width: 2px;
		border-style: solid;
		padding: 10px;
		font-size: 14px;
		font-weight: bold;
		color: white;
		line-height: 26px;
	}
	.error {
		background-color: #c00;
		border-color: #900;
	}
	.warning {
		background-color: #cc0;
		border-color: #990;
	}
	.success {
		background-color: #0c0;
		border-color: #090;
	}
</style>
</head>

<body>
	<? if (is_string($error)) { ?><p class="error"><? echo nl2br(htmlspecialchars($error)); ?></p><? } ?>
	<? if (is_string($warning)) { ?><p class="warning"><? echo nl2br(htmlspecialchars($warning)); ?></p><? } ?>
	<? if (is_string($success)) { ?><p class="success"><? echo nl2br(htmlspecialchars($success)); ?></p><? } ?>
	<p>Enter an IMEI and find whether an HTC tool is available for your phone !</p>
	<form action="" method="post" onsubmit="document.getElementById('Lookup').disabled = true;">
		<input type="text" name="IMEI" size="15" maxlength="15" value="<? if (isset($_POST['IMEI'])) echo htmlspecialchars($_POST['IMEI']); ?>" />
		<input type="submit" name"Lookup" id="Lookup" value="Lookup" onclick="this.value = 'Please wait...';" />
	</form>
</body>
</html>